class MW_Mutator expands Mutator;

var DeathMatchPlus MyGame;

function PreBeginPlay ()
{
	Super.PreBeginPlay();

	AddMutator(Level.Spawn(class'MW_ScoringMutator'));
}

/*
function ModifyPlayer(Pawn Other)
{
	if ( NextMutator != None )
		NextMutator.ModifyPlayer(Other);
}
*/

function PostBeginPlay()
{
	MyGame = DeathMatchPlus(Level.Game);
	Super.PostBeginPlay();
}

function bool AlwaysKeep(Actor Other)
{
	local bool bTemp;

	if ( Other.IsA('StationaryPawn') )
		return true;
	if (Other.IsA('PlayerPawn'))
        {
		PlayerPawn(Other).PlayerReplicationInfoClass = class'MW_PRI';
		return true;
		}
	if (Other.IsA('Carcass'))
		{
		Carcass(Other).Style = STY_Translucent;
		Carcass(Other).bProjTarget = False;
		Carcass(Other).bBlockPlayers = False;
		}
		
	if ( NextMutator != None )
		return ( NextMutator.AlwaysKeep(Other) );
	return false;
}

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
	local Inventory Inv;

	// replace Unreal I inventory actors by their Unreal Tournament equivalents
	// set bSuperRelevant to false if want the gameinfo's super.IsRelevant() function called
	// to check on relevancy of this actor.

	bSuperRelevant = 1;
	if ( MyGame.bMegaSpeed && Other.bIsPawn && Pawn(Other).bIsPlayer )
	{
		Pawn(Other).GroundSpeed *= 1.4;
		Pawn(Other).WaterSpeed *= 1.4;
		Pawn(Other).AirSpeed *= 1.4;
		Pawn(Other).AccelRate *= 1.4;
	}

	if ( Other.IsA('StationaryPawn') )
		return true;
	
	//Temp untill maps are build:
	if ( Other.IsA('TournamentWeapon') )
		{
		return false;
		}
		
	//Temp untill maps are build:
	if ( Other.IsA('TournamentAmmo') )
		{
		return false;
		}
	
	Inv = Inventory(Other);
 	if ( Inv == None )
	{
		bSuperRelevant = 0;
		if ( Other.IsA('TorchFlame') )
			Other.NetUpdateFrequency = 0.5;
		return true;
	}

	if ( MyGame.bNoviceMode && MyGame.bRatedGame && (Level.NetMode == NM_Standalone) )
		Inv.RespawnTime *= (0.5 + 0.1 * MyGame.Difficulty);

	/*
	if ( Other.IsA('Armor') )
	{
		ReplaceWith( Other, "Botpack.Armor2" );
		return false;
	}
	*/
	
	bSuperRelevant = 0;
	return true;
}

function bool PreventDeath (Pawn Killed, Pawn Killer, name damageType, vector HitLocation)
{
local Inventory Inv;

if ( Killed != None && Killer != None )
	{
/*	
	if ( Killed.Inventory != none )
		{
		for (inv=Killed.Inventory; inv!=None; inv=inv.Inventory)
			{
			Killed.Inventory.Destroy();
			}
		}
*/
	
	//Weapons to drop:
	//DropBaseEnforcer(Killed);
	//DropBaseMinigun(Killed);
	//DropBasePulseGun(Killed);
	//DropBaseSniperRifle(Killed);
	//DropBaseRazorJack(Killed);
	//DropBaseFlakCannon(Killed);
	//DropBaseShockRifle(Killed);
	DropBaseRocketLauncher(Killed);
	
	//Ammo To Drop:
	//DropAmmoEnforcer(Killed);
	//DropAmmoMinigun(Killed);
	//DropAmmoPulseGun(Killed);
	//DropAmmoSniperRifle(Killed);
	//DropAmmoRazorJack(Killed);
	//DropAmmoFlakCannon(Killed);
	//DropAmmoShockRifle(Killed);
	DropAmmoRocketLauncher(Killed);
	
	//Pickups to drop:
	//DropDollarPickup(Killed);
	
	
	if ( NextMutator != None )
		{
		NextMutator.PreventDeath(Killer, Killed, damageType, HitLocation);
		}
	}
}

//-------------------------- Weapon droppings: -------------------------------------
function DropBaseEnforcer(Pawn Other)
{
local Weapon_BaseEnforcer DropItem;
local float speed;

	speed = VSize(Other.Velocity);
	
	DropItem = Spawn(Class'Weapon_BaseEnforcer',,,Other.Location);
	DropItem.RemoteRole = ROLE_DumbProxy;
	DropItem.SetPhysics(PHYS_Falling);
	DropItem.bCollideWorld = true;
	DropItem.Velocity = Normal(Other.Velocity/speed + 0.5 * VRand()) * (speed + 500);
	DropItem.RespawnTime = 0.0;
}

function DropBaseMinigun(Pawn Other)
{
local Weapon_BaseMinigun DropItem;
local float speed;

	speed = VSize(Other.Velocity);
	
	DropItem = Spawn(Class'Weapon_BaseMinigun',,,Other.Location);
	DropItem.RemoteRole = ROLE_DumbProxy;
	DropItem.SetPhysics(PHYS_Falling);
	DropItem.bCollideWorld = true;
	DropItem.Velocity = Normal(Other.Velocity/speed + 0.5 * VRand()) * (speed + 500);
	DropItem.RespawnTime = 0.0;
}

function DropBasePulseGun(Pawn Other)
{
local Weapon_BasePulseGun DropItem;
local float speed;

	speed = VSize(Other.Velocity);
	
	DropItem = Spawn(Class'Weapon_BasePulseGun',,,Other.Location);
	DropItem.RemoteRole = ROLE_DumbProxy;
	DropItem.SetPhysics(PHYS_Falling);
	DropItem.bCollideWorld = true;
	DropItem.Velocity = Normal(Other.Velocity/speed + 0.5 * VRand()) * (speed + 500);
	DropItem.RespawnTime = 0.0;
}

function DropBaseSniperRifle(Pawn Other)
{
local Weapon_BaseSniperRifle DropItem;
local float speed;

	speed = VSize(Other.Velocity);
	
	DropItem = Spawn(Class'Weapon_BaseSniperRifle',,,Other.Location);
	DropItem.RemoteRole = ROLE_DumbProxy;
	DropItem.SetPhysics(PHYS_Falling);
	DropItem.bCollideWorld = true;
	DropItem.Velocity = Normal(Other.Velocity/speed + 0.5 * VRand()) * (speed + 500);
	DropItem.RespawnTime = 0.0;
}

function DropBaseRazorJack(Pawn Other)
{
local Weapon_BaseRazorJack DropItem;
local float speed;

	speed = VSize(Other.Velocity);
	
	DropItem = Spawn(Class'Weapon_BaseRazorJack',,,Other.Location);
	DropItem.RemoteRole = ROLE_DumbProxy;
	DropItem.SetPhysics(PHYS_Falling);
	DropItem.bCollideWorld = true;
	DropItem.Velocity = Normal(Other.Velocity/speed + 0.5 * VRand()) * (speed + 500);
	DropItem.RespawnTime = 0.0;
}

function DropBaseFlakCannon(Pawn Other)
{
local Weapon_BaseFlakCannon DropItem;
local float speed;

	speed = VSize(Other.Velocity);
	
	DropItem = Spawn(Class'Weapon_BaseFlakCannon',,,Other.Location);
	DropItem.RemoteRole = ROLE_DumbProxy;
	DropItem.SetPhysics(PHYS_Falling);
	DropItem.bCollideWorld = true;
	DropItem.Velocity = Normal(Other.Velocity/speed + 0.5 * VRand()) * (speed + 500);
	DropItem.RespawnTime = 0.0;
}

function DropBaseShockRifle(Pawn Other)
{
local Weapon_BaseShockRifle DropItem;
local float speed;

	speed = VSize(Other.Velocity);
	
	DropItem = Spawn(Class'Weapon_BaseShockRifle',,,Other.Location);
	DropItem.RemoteRole = ROLE_DumbProxy;
	DropItem.SetPhysics(PHYS_Falling);
	DropItem.bCollideWorld = true;
	DropItem.Velocity = Normal(Other.Velocity/speed + 0.5 * VRand()) * (speed + 500);
	DropItem.RespawnTime = 0.0;
}

function DropBaseRocketLauncher(Pawn Other)
{
local Weapon_BaseRocketLauncher DropItem;
local float speed;

	speed = VSize(Other.Velocity);
	
	DropItem = Spawn(Class'Weapon_BaseRocketLauncher',,,Other.Location);
	DropItem.RemoteRole = ROLE_DumbProxy;
	DropItem.SetPhysics(PHYS_Falling);
	DropItem.bCollideWorld = true;
	DropItem.Velocity = Normal(Other.Velocity/speed + 0.5 * VRand()) * (speed + 500);
	DropItem.RespawnTime = 0.0;
}
//-------------------------- Ammo droppings: -------------------------------------
function DropAmmoEnforcer(Pawn Other)
{
local Ammo_Enforcer DropItem;
local float speed;

	speed = VSize(Other.Velocity);

	DropItem = Spawn(Class'Ammo_Enforcer',,,Other.Location);
	DropItem.RemoteRole = ROLE_DumbProxy;
	DropItem.SetPhysics(PHYS_Falling);
	DropItem.bCollideWorld = true;
	DropItem.Velocity = Normal(Other.Velocity/speed + 0.5 * VRand()) * (speed + 500);
	DropItem.RespawnTime = 0.0;
	DropItem.bRotatingPickup = False;
}

function DropAmmoMinigun(Pawn Other)
{
local Ammo_Minigun DropItem;
local float speed;

	speed = VSize(Other.Velocity);

	DropItem = Spawn(Class'Ammo_Minigun',,,Other.Location);
	DropItem.RemoteRole = ROLE_DumbProxy;
	DropItem.SetPhysics(PHYS_Falling);
	DropItem.bCollideWorld = true;
	DropItem.Velocity = Normal(Other.Velocity/speed + 0.5 * VRand()) * (speed + 500);
	DropItem.RespawnTime = 0.0;
	DropItem.bRotatingPickup = False;
}

function DropAmmoPulseGun(Pawn Other)
{
local Ammo_PulseGun DropItem;
local float speed;

	speed = VSize(Other.Velocity);

	DropItem = Spawn(Class'Ammo_PulseGun',,,Other.Location);
	DropItem.RemoteRole = ROLE_DumbProxy;
	DropItem.SetPhysics(PHYS_Falling);
	DropItem.bCollideWorld = true;
	DropItem.Velocity = Normal(Other.Velocity/speed + 0.5 * VRand()) * (speed + 500);
	DropItem.RespawnTime = 0.0;
	DropItem.bRotatingPickup = False;
}

function DropAmmoSniperRifle(Pawn Other)
{
local Ammo_SniperRifle DropItem;
local float speed;

	speed = VSize(Other.Velocity);

	DropItem = Spawn(Class'Ammo_SniperRifle',,,Other.Location);
	DropItem.RemoteRole = ROLE_DumbProxy;
	DropItem.SetPhysics(PHYS_Falling);
	DropItem.bCollideWorld = true;
	DropItem.Velocity = Normal(Other.Velocity/speed + 0.5 * VRand()) * (speed + 500);
	DropItem.RespawnTime = 0.0;
	DropItem.bRotatingPickup = False;
}

function DropAmmoRazorJack(Pawn Other)
{
local Ammo_RazorJack DropItem;
local float speed;

	speed = VSize(Other.Velocity);

	DropItem = Spawn(Class'Ammo_RazorJack',,,Other.Location);
	DropItem.RemoteRole = ROLE_DumbProxy;
	DropItem.SetPhysics(PHYS_Falling);
	DropItem.bCollideWorld = true;
	DropItem.Velocity = Normal(Other.Velocity/speed + 0.5 * VRand()) * (speed + 500);
	DropItem.RespawnTime = 0.0;
	DropItem.bRotatingPickup = False;
}

function DropAmmoFlakCannon(Pawn Other)
{
local Ammo_FlakCannon DropItem;
local float speed;

	speed = VSize(Other.Velocity);

	DropItem = Spawn(Class'Ammo_FlakCannon',,,Other.Location);
	DropItem.RemoteRole = ROLE_DumbProxy;
	DropItem.SetPhysics(PHYS_Falling);
	DropItem.bCollideWorld = true;
	DropItem.Velocity = Normal(Other.Velocity/speed + 0.5 * VRand()) * (speed + 500);
	DropItem.RespawnTime = 0.0;
	DropItem.bRotatingPickup = False;
}

function DropAmmoShockRifle(Pawn Other)
{
local Ammo_ShockRifle DropItem;
local float speed;

	speed = VSize(Other.Velocity);

	DropItem = Spawn(Class'Ammo_ShockRifle',,,Other.Location);
	DropItem.RemoteRole = ROLE_DumbProxy;
	DropItem.SetPhysics(PHYS_Falling);
	DropItem.bCollideWorld = true;
	DropItem.Velocity = Normal(Other.Velocity/speed + 0.5 * VRand()) * (speed + 500);
	DropItem.RespawnTime = 0.0;
	DropItem.bRotatingPickup = False;
}

function DropAmmoRocketLauncher(Pawn Other)
{
local Ammo_RocketLauncher DropItem;
local float speed;

	speed = VSize(Other.Velocity);

	DropItem = Spawn(Class'Ammo_RocketLauncher',,,Other.Location);
	DropItem.RemoteRole = ROLE_DumbProxy;
	DropItem.SetPhysics(PHYS_Falling);
	DropItem.bCollideWorld = true;
	DropItem.Velocity = Normal(Other.Velocity/speed + 0.5 * VRand()) * (speed + 500);
	DropItem.RespawnTime = 0.0;
	DropItem.bRotatingPickup = False;
}
//-------------------------- Pickup droppings: -------------------------------------
function DropDollarPickup(Pawn Other)
{
local Pickup_Dollar DropItem;
local float speed;
local int amount;

	speed = VSize(Other.Velocity);
	amount = 5 + Rand(21);
	
	DropItem = Spawn(Class'Pickup_Dollar',,,Other.Location);
	DropItem.RemoteRole = ROLE_DumbProxy;
	DropItem.SetPhysics(PHYS_Falling);
	DropItem.bCollideWorld = true;
	DropItem.Velocity = Normal(Other.Velocity/speed + 0.5 * VRand()) * (speed + 500);
	DropItem.RespawnTime = 0.0;
	DropItem.bRotatingPickup = True;
	DropItem.NumDollars = amount;
}

defaultproperties
{
}
